// NapedOptycznyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NapedOptyczny.h"
#include "NapedOptycznyDlg.h"
#include "Mmsystem.h"
#pragma comment(lib, "Winmm.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CNapedOptycznyDlg dialog

CNapedOptycznyDlg::CNapedOptycznyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNapedOptycznyDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNapedOptycznyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, Edit1);
	DDX_Control(pDX, IDC_SLIDER1, Slider1);
	DDX_Control(pDX, IDC_SLIDER2, Slider2);
	DDX_Control(pDX, IDC_SLIDER3, Slider3);
	DDX_Control(pDX, IDC_SLIDER4, Slider4);
	DDX_Control(pDX, IDC_COMBO1, ComboBox1);
}

BEGIN_MESSAGE_MAP(CNapedOptycznyDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CNapedOptycznyDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CNapedOptycznyDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CNapedOptycznyDlg::OnBnClickedButton3)
	ON_CBN_SELCHANGE(IDC_COMBO1, &CNapedOptycznyDlg::OnCbnSelchangeCombo1)
	ON_BN_CLICKED(IDC_BUTTON4, &CNapedOptycznyDlg::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON12, &CNapedOptycznyDlg::OnBnClickedButton12)
	ON_BN_CLICKED(IDC_BUTTON9, &CNapedOptycznyDlg::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON10, &CNapedOptycznyDlg::OnBnClickedButton10)
	ON_NOTIFY(TRBN_THUMBPOSCHANGING, IDC_SLIDER3, &CNapedOptycznyDlg::OnTRBNThumbPosChangingSlider3)
	ON_NOTIFY(TRBN_THUMBPOSCHANGING, IDC_SLIDER4, &CNapedOptycznyDlg::OnTRBNThumbPosChangingSlider3)
	ON_NOTIFY(TRBN_THUMBPOSCHANGING, IDC_SLIDER1, &CNapedOptycznyDlg::OnTRBNThumbPosChangingSlider1)
	ON_NOTIFY(TRBN_THUMBPOSCHANGING, IDC_SLIDER2, &CNapedOptycznyDlg::OnTRBNThumbPosChangingSlider1)
	ON_BN_CLICKED(IDC_BUTTON5, &CNapedOptycznyDlg::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON6, &CNapedOptycznyDlg::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, &CNapedOptycznyDlg::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON8, &CNapedOptycznyDlg::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON11, &CNapedOptycznyDlg::OnBnClickedButton11)
END_MESSAGE_MAP()


// CNapedOptycznyDlg message handlers

BOOL CNapedOptycznyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	TCHAR buf[50];
	GetLogicalDriveStringsW(sizeof(buf)/sizeof(TCHAR), buf);

	for (TCHAR* s=buf; *s; s+=_tcslen(s)+1) 
	{
		int i = 0;
		CString sDrivePath = s;
		sDrivePath.Delete(sDrivePath.GetLength()-1, 1);
		UINT uDriveType = GetDriveType(sDrivePath);	
		if(uDriveType == DRIVE_CDROM)
			ComboBox1.AddString(sDrivePath);			
	}
	
	USHORT kanalLewy, kanalPrawy;
	CzytajPoziomGlosnosciCDAudio(kanalLewy, kanalPrawy);

	Slider1.SetRangeMin(0);
	Slider1.SetRangeMax(255);
    Slider1.SetTicFreq(15);
	Slider1.SetPos(kanalLewy);
	
	Slider2.SetRangeMin(0);
	Slider2.SetRangeMax(255);
    Slider2.SetTicFreq(15);
    Slider2.SetPos(kanalPrawy);

	CzytajPoziomGlosnosciWave(kanalLewy, kanalPrawy);
	Slider3.SetRangeMin(0);
	Slider3.SetRangeMax(255);
    Slider3.SetTicFreq(15);
	Slider3.SetPos(kanalLewy);
	
	Slider4.SetRangeMin(0);
	Slider4.SetRangeMax(255);
    Slider4.SetTicFreq(15);
    Slider4.SetPos(kanalPrawy);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNapedOptycznyDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNapedOptycznyDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CNapedOptycznyDlg::KontrolaTackiCD(LPCTSTR Drive, BOOL Operacja)
{
	BOOL Wynik = FALSE;

	MCI_OPEN_PARMS parametry;
	parametry.dwCallback = 0; //uchwyt okna, do ktorego moglyby byc wysylane komunikaty powiadamiajace o wysunieciu tacki
	parametry.lpstrDeviceType = L"CDAudio";
	parametry.lpstrElementName = Drive; //Symbol dysku w formacie X:

	//Inicjalizacja urzadzenia
	mciSendCommand(0, MCI_OPEN, MCI_OPEN_ELEMENT | MCI_OPEN_TYPE, (long)&parametry);

	if (Operacja)
		//Otwieranie napedu CDROM
		Wynik = (mciSendCommand(parametry.wDeviceID, MCI_SET, MCI_SET_DOOR_OPEN, 0) == 0);
	else
		//Zamykanie napedu CDROM
		Wynik = (mciSendCommand(parametry.wDeviceID, MCI_SET, MCI_SET_DOOR_CLOSED, 0) == 0);

	//zwolnienie dostepu do urzadzenia
	mciSendCommand(parametry.wDeviceID, MCI_CLOSE, MCI_NOTIFY, (long)&parametry);
/*	
	MCIERROR mciBlad = mciSendCommand(0,MCI_OPEN,MCI_OPEN_ELEMENT | MCI_OPEN_TYPE, (long)&parametry);
	if (mciBlad != 0)
	{
		wchar_t opisBledu[MAXERRORLENGTH];
		mciGetErrorString(mciBlad, opisBledu, MAXERRORLENGTH);
		AfxMessageBox(opisBledu);
		return FALSE;
	}
*/
	return Wynik;
}

BOOL CNapedOptycznyDlg::OpenCD(LPCTSTR Drive)
{
	return KontrolaTackiCD(Drive, TRUE);
}

BOOL CNapedOptycznyDlg::CloseCD(LPCTSTR Drive)
{
	return KontrolaTackiCD(Drive, FALSE);
}

int CNapedOptycznyDlg::StanCDAudio(LPCTSTR Drive)
{
	MCI_OPEN_PARMS parametry;
	parametry.dwCallback = 0;
	parametry.lpstrDeviceType = L"CDAudio";
	parametry.lpstrElementName = Drive; //Litera dysku musi byc np. "X:"
	mciSendCommand(0, MCI_OPEN, MCI_OPEN_ELEMENT | MCI_OPEN_TYPE, (long)&parametry);

	MCI_STATUS_PARMS stan;
	stan.dwItem = MCI_STATUS_MODE;
	mciSendCommand(parametry.wDeviceID,MCI_STATUS,MCI_WAIT | MCI_STATUS_ITEM,(long)&stan);
	int Wynik=stan.dwReturn; //stan MCI zaczyna sie od 524

	mciSendCommand(parametry.wDeviceID,MCI_CLOSE,MCI_NOTIFY,(long)&parametry);
	return Wynik;
}

BOOL CNapedOptycznyDlg::IsCDAudio(LPCTSTR Drive)
{
	MCI_OPEN_PARMS parametry;
	parametry.dwCallback = 0;
	parametry.lpstrDeviceType = L"CDAudio";
	parametry.lpstrElementName = Drive;
	MCIERROR mciBlad = mciSendCommand(0, MCI_OPEN, MCI_OPEN_ELEMENT | MCI_OPEN_TYPE,(long)&parametry);
	if (mciBlad != 0) return FALSE;

	MCI_STATUS_PARMS stanNapedu;
	stanNapedu.dwCallback = 0;
	stanNapedu.dwItem = MCI_CDA_STATUS_TYPE_TRACK;
	stanNapedu.dwTrack = 1;
	mciBlad=mciSendCommand(parametry.wDeviceID,MCI_STATUS,MCI_TRACK | MCI_STATUS_ITEM,(long)&stanNapedu);
	if (mciBlad!=0) return FALSE;

	BOOL Wynik;
	switch (stanNapedu.dwReturn)
	{
		case MCI_CDA_TRACK_AUDIO: Wynik = TRUE; break;
		default: Wynik = FALSE; break;
	}

	mciSendCommand(parametry.wDeviceID, MCI_CLOSE, MCI_NOTIFY, (long)&parametry);
	return Wynik;
}

BOOL CNapedOptycznyDlg::KontrolaCDAudio(LPCTSTR Drive, ULONG Operacja)
{
	MCI_OPEN_PARMS parametry;
	parametry.dwCallback = 0;
	parametry.lpstrDeviceType = L"CDAudio";
	parametry.lpstrElementName = Drive; //Litera dysku musi byc np. "X:"
	mciSendCommand(0, MCI_OPEN, MCI_OPEN_ELEMENT | MCI_OPEN_TYPE, (long)&parametry);

	BOOL Wynik=(mciSendCommand(parametry.wDeviceID, Operacja, 0, 0) == 0);

	mciSendCommand(parametry.wDeviceID,MCI_CLOSE,MCI_NOTIFY,(long)&parametry);
	return Wynik;
}

BOOL CNapedOptycznyDlg::PlayAudioCD(LPCTSTR Drive)
{
	return KontrolaCDAudio(Drive, MCI_PLAY);
}

BOOL CNapedOptycznyDlg::ResumeCDAudio(LPCTSTR Drive)
{
	return KontrolaCDAudio(Drive, MCI_RESUME);
}

BOOL CNapedOptycznyDlg::PauseCDAudio(LPCTSTR Drive)
{
	if (StanCDAudio(Drive) != 525) 
		return KontrolaCDAudio(Drive, MCI_PAUSE); //gdy odtwarzanie
	else 
		return ResumeCDAudio(Drive); //gdy zatrzymany
}

BOOL CNapedOptycznyDlg::StopCDAudio(LPCTSTR Drive)
{
	return KontrolaCDAudio(Drive, MCI_STOP);
}

void CNapedOptycznyDlg::UstalPoziomGlosnosciWave(USHORT kanalLewy, USHORT kanalPrawy)
{
	ULONG glosnosc = (kanalLewy << 24) | (kanalPrawy << 8);
	waveOutSetVolume((HWAVEOUT)WAVE_MAPPER, glosnosc);	
}

void CNapedOptycznyDlg::CzytajPoziomGlosnosciWave(USHORT &kanalLewy, USHORT &kanalPrawy)
{
	ULONG glosnosc;
	waveOutGetVolume((HWAVEOUT)WAVE_MAPPER, &glosnosc);
	kanalLewy = (USHORT)((glosnosc & 0xFFFF0000) >> 24);
	kanalPrawy = (USHORT)((glosnosc & 0x0000FFFF) >> 8);
}

BOOL CNapedOptycznyDlg::UstalPoziomGlosnosciCDAudio(USHORT kanalLewy, USHORT kanalPrawy)
{
	ULONG glosnosc = (kanalLewy << 24) | (kanalPrawy << 8);
	return (auxSetVolume(AUX_MAPPER, glosnosc) == MMSYSERR_NOERROR);
}

BOOL CNapedOptycznyDlg::CzytajPoziomGlosnosciCDAudio(USHORT &kanalLewy, USHORT &kanalPrawy)
{
	ULONG glosnosc;
	BOOL Wynik = (auxGetVolume(AUX_MAPPER,&glosnosc) == MMSYSERR_NOERROR);
	kanalLewy = (USHORT)((glosnosc & 0xFFFF0000) >> 24);
	kanalPrawy = (USHORT)((glosnosc & 0x0000FFFF) >> 8);
	return Wynik;
}

void CNapedOptycznyDlg::OnBnClickedButton1()
{
	if(m_Drive != L"")
		OpenCD(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton2()
{
	if(m_Drive != L"")
		CloseCD(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton3()
{
	if(m_Drive != L"")
	{
		switch (StanCDAudio(m_Drive))
		{
			case 1242348: AfxMessageBox(L"Symbol nie wskazuje napdu CD"); break;
			case 1242732: AfxMessageBox(L"Brak napdu CD"); break;
			case 530: AfxMessageBox(L"Brak pyty"); break;
			case 525: AfxMessageBox(L"Zatrzymany"); break;
			case 526: AfxMessageBox(L"Odtwarzanie"); break;
			default: 
				CString temp;
				temp.Format(L"%d", StanCDAudio(m_Drive));
				AfxMessageBox(temp); 
				break;
		}
	}
}

void CNapedOptycznyDlg::OnCbnSelchangeCombo1()
{
	CString temp;
	int n = ComboBox1.GetCurSel();
	if(n != -1)
	{
		ComboBox1.GetLBText(n, temp);
		m_Drive = temp;
	}
	else
		m_Drive = L"";
}

void CNapedOptycznyDlg::OnBnClickedButton4()
{
	if(m_Drive != L"")
		IsCDAudio(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton12()
{
	if (waveOutGetNumDevs == 0) 
		AfxMessageBox(L"Brak karty dwikowej!");
	else 
		AfxMessageBox(L"Karta dwikowa jest zainstalowana");
}

void CNapedOptycznyDlg::OnBnClickedButton9()
{
	CFileDialog cf(TRUE, L".wav", 0, 4, L"Pliki .wav (*.wav)|*.wav||)");
	CString path;
	if(cf.DoModal())
	{
		path.Format(L"%s\\%s", cf.GetFolderPath(), cf.GetFileName());
		Edit1.SetWindowTextW(path);
	}
	else
		AfxMessageBox(L"Nie wybrano pliku");
}

void CNapedOptycznyDlg::OnBnClickedButton10()
{
	//PlaySound(L"c:\\WINDOWS\\MEDIA\\Windows Logon Sound.wav", 0, SND_FILENAME | SND_ASYNC);
	//PlaySound((LPCWSTR)SND_ALIAS_SYSTEMSTART, 0, SND_ALIAS_ID | SND_ASYNC);
	CString path;
	Edit1.GetWindowTextW(path);
	PlaySound(path, 0, SND_FILENAME | SND_ASYNC);
}

void CNapedOptycznyDlg::OnTRBNThumbPosChangingSlider3(NMHDR *pNMHDR, LRESULT *pResult)
{
	// This feature requires Windows Vista or greater.
	// The symbol _WIN32_WINNT must be >= 0x0600.
	NMTRBTHUMBPOSCHANGING *pNMTPC = reinterpret_cast<NMTRBTHUMBPOSCHANGING *>(pNMHDR);
	// TODO: Add your control notification handler code here
	
	UstalPoziomGlosnosciWave(Slider3.GetPos(), Slider4.GetPos());

	*pResult = 0;
}

void CNapedOptycznyDlg::OnTRBNThumbPosChangingSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// This feature requires Windows Vista or greater.
	// The symbol _WIN32_WINNT must be >= 0x0600.
	NMTRBTHUMBPOSCHANGING *pNMTPC = reinterpret_cast<NMTRBTHUMBPOSCHANGING *>(pNMHDR);
	// TODO: Add your control notification handler code here
	
	UstalPoziomGlosnosciCDAudio(Slider1.GetPos(), Slider2.GetPos());

	*pResult = 0;
}

void CNapedOptycznyDlg::OnBnClickedButton5()
{
	if(m_Drive != L"")
		PlayAudioCD(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton6()
{
	if(m_Drive != L"")
		PauseCDAudio(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton7()
{
	if(m_Drive != L"")
		ResumeCDAudio(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton8()
{
	if(m_Drive != L"")
		StopCDAudio(m_Drive);
}

void CNapedOptycznyDlg::OnBnClickedButton11()
{
	PlaySound(NULL, 0, 0);		
}
